
#ifndef EIP93_C_ADAPTER_H
#define EIP93_C_ADAPTER_H

#include "mtk_csAdapter.h"

#ifndef ADAPTER_MAX_DMARESOURCE_HANDLES
#define ADAPTER_MAX_DMARESOURCE_HANDLES  256
#endif

#ifndef ADAPTER_EIP93_RINGSIZE_BYTES
#define ADAPTER_EIP93_RINGSIZE_BYTES 1024
#endif

#ifndef ADAPTER_PACKETSIDECHANNEL_MAX_RECORDS
#ifdef ADAPTER_EIP93_SEPARATE_RINGS
#define ADAPTER_PACKETSIDECHANNEL_MAX_RECORDS  (2 * \
             (ADAPTER_EIP93_RINGSIZE_BYTES / (8*4)))
#else
#define ADAPTER_PACKETSIDECHANNEL_MAX_RECORDS  (\
                    ADAPTER_EIP93_RINGSIZE_BYTES /(8*4))
#endif
#endif

#ifndef ADAPTER_MAX_EIP93LOGICDESCR
#define ADAPTER_MAX_EIP93LOGICDESCR 32
#endif

#ifndef ADAPTER_EIP93_DESCRIPTORDONETIMEOUT
#define ADAPTER_EIP93_DESCRIPTORDONETIMEOUT  0
#endif



#ifndef ADAPTER_EIP93_DMATHRESHOLD_INPUT
#define ADAPTER_EIP93_DMATHRESHOLD_INPUT  128
#endif

#ifndef ADAPTER_EIP93_DMATHRESHOLD_OUTPUT
#define ADAPTER_EIP93_DMATHRESHOLD_OUTPUT  128
#endif

#ifndef ADAPTER_EIP93_DHM_THRESHOLD_INPUT
#define ADAPTER_EIP93_DHM_THRESHOLD_INPUT  128
#endif

#ifndef ADAPTER_EIP93_DHM_THRESHOLD_OUTPUT
#define ADAPTER_EIP93_DHM_THRESHOLD_OUTPUT 128
#endif

// ensure only one of the packet engine modes is activated
#ifdef ADAPTER_EIP93_PE_MODE_DHM
#ifdef ADAPTER_EIP93_PE_MODE_ARM
#error "Multiple ADAPTER_EIP93_PE_MODE_ defined in mtk_csAdapter.h"
#endif
#endif



#ifndef ADAPTER_DRIVER_NAME
#define ADAPTER_DRIVER_NAME "safenet_eip93_vdriver"
#endif

#ifndef ADAPTER_INTERRUPTS_TRACEFILTER
#define ADAPTER_INTERRUPTS_TRACEFILTER BIT_31
#endif

#ifndef ADAPTER_EIP75_ALARMINTERRUPTTHRESHOLD
#define ADAPTER_EIP75_ALARMINTERRUPTTHRESHOLD 10
#endif


#endif 

